{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1995-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.SysConst;

interface

resourcestring
  SUnknown = '<unknown>';
  SInvalidInteger = '''%s'' is not a valid integer value';
  SInvalidFloat = '''%s'' is not a valid floating point value';
  SInvalidCurrency = '''%s'' is not a valid currency value';
  SInvalidDate = '''%s'' is not a valid date';
  SInvalidTime = '''%s'' is not a valid time';
  SInvalidDateTime = '''%s'' is not a valid date and time';
  SInvalidDateTimeFloat = '''%g'' is not a valid date and time';
  SInvalidTimeStamp = '''%d.%d'' is not a valid timestamp';
  SInvalidGUID = '''%s'' is not a valid GUID value';
  SInvalidBoolean = '''%s'' is not a valid boolean value';
  STimeEncodeError = 'Invalid argument to time encode';
  SDateEncodeError = 'Invalid argument to date encode';
  SOutOfMemory = 'Out of memory';
  SInOutError = 'I/O error %d';
  SFileNotFound = 'File not found';
  SInvalidFilename = 'Invalid filename';
  STooManyOpenFiles = 'Too many open files';
  SAccessDenied = 'File access denied';
  SEndOfFile = 'Read beyond end of file';
  SDiskFull = 'Disk full';
  SInvalidInput = 'Invalid numeric input';
  SDivByZero = 'Division by zero';
  SRangeError = 'Range check error';
  SIntOverflow = 'Integer overflow';
  SInvalidOp = 'Invalid floating point operation';
  SZeroDivide = 'Floating point division by zero';
  SOverflow = 'Floating point overflow';
  SUnderflow = 'Floating point underflow';
  SInvalidPointer = 'Invalid pointer operation';
  SInvalidCast = 'Invalid class typecast';
  SAccessViolationArg3 = 'Access violation at address %p. %s of address %p';
  SAccessViolationNoArg = 'Access violation';
  SStackOverflow = 'Stack overflow';
  SControlC = 'Control-C hit';
  SQuit = 'Quit key hit';
  SPrivilege = 'Privileged instruction';
  SOperationAborted = 'Operation aborted';
  SException = 'Exception %s in module %s at %p.' + sLineBreak + '%s%s' + sLineBreak;
  SExceptTitle = 'Application Error';
  SInvalidFormat = 'Format ''%s'' invalid or incompatible with argument';
  SArgumentMissing = 'No argument for format ''%s''';
  SDispatchError = 'Variant method calls not supported';
  SReadAccess = 'Read';
  SWriteAccess = 'Write';
  SResultTooLong = 'Format result longer than 4096 characters';
  SFormatTooLong = 'Format string too long';

  SVarArrayCreate = 'Error creating variant or safe array';
  SVarArrayBounds = 'Variant or safe array index out of bounds';
  SVarArrayLocked = 'Variant or safe array is locked';
  SVarArrayWithHResult = 'Unexpected variant or safe array error: %s%.8x';

  SVariantInvalidOpOn1 = 'Invalid variant operation on %s variant';
  SVariantInvalidOpOn2 = 'Invalid variant operation with %s and %s variants';
  SVariantInvalidOpXOn1 = 'Invalid variant operation (%s) with %s and %s variants';
  SVariantInvalidOpXOn2 = 'Invalid variant operation (%s) with %s and %s variants';
  SVariantInvalidInvoke = 'Invalid variant invocation (%s) on %s variant';
  SVariantInvalidVarType = 'Invalid variant type (0x%.4x)';
  SVariantTypeCastOn = 'Invalid variant type conversion of %s variant';
  SVariantTypeCastTo = 'Invalid variant type conversion of %s variant into %s';
  SVariantArrayCreateErrorIllegalBounds = 'Cannot create a variant array using an illegal bounds array';
  SVariantArrayInvalidDim = 'Invalid variant array dimension (%d)';

  SInvalidVarCast = 'Invalid variant type conversion';
  SInvalidVarOp = 'Invalid variant operation';
  SInvalidVarNullOp = 'Invalid NULL variant operation (%s)';
  SVarTypeRangeCheck1 = 'Range check error for %s variant';
  SVarTypeRangeCheck2 = 'Range check error while converting %s variant into %s';
  SVarTypeTooManyCustomTypes = 'Too many custom variant types have been registered';

  // the following are not used anymore
  SVarTypeCouldNotConvert = 'Could not convert %s variant into %s';
  SVarTypeConvertOverflow1 = 'Overflow while converting %s variant';
  SVarTypeConvertOverflow2 = 'Overflow while converting %s variant into %s';
  SVarOverflow = 'Variant overflow';
  SVarInvalid = 'Invalid argument';
  SVarBadType = 'Invalid variant type';
  SVarNotImplemented = 'Operation not supported';
  SVarOutOfMemory = 'Variant operation ran out memory';
  SVarUnexpected = 'Unexpected variant error';
  SVarDataClearRecursing = 'Recursion while doing a VarDataClear';
  SVarDataCopyRecursing = 'Recursion while doing a VarDataCopy';
  SVarDataCopyNoIndRecursing = 'Recursion while doing a VarDataCopyNoInd';
  SVarDataInitRecursing = 'Recursion while doing a VarDataInit';
  SVarDataCastToRecursing = 'Recursion while doing a VarDataCastTo';
  SVarIsEmpty = 'Variant is empty';

  SInvalidVarOpWithHResultWithPrefix = 'Invalid variant operation: %s%.8x'#10'%s';
  SVarTypeOutOfRangeWithPrefix = 'Custom variant type (%s%.4x) is out of range';
  SVarTypeAlreadyUsedWithPrefix = 'Custom variant type (%s%.4x) already used by %s';
  SVarTypeNotUsableWithPrefix = 'Custom variant type (%s%.4x) is not usable';

  { The following are no longer used, see suggested alternative string resource
  SVarTypeConvertOverflow =  SVarTypeConvertOverflow2 deprecated;
  SVarNotArray =             SVarInvalid deprecated;
  SVarTypeUnknown =          SVarTypeNotUsableWithPrefix deprecated;
  SVarTypeOutOfRange =       SVarTypeOutOfRangeWithPrefix deprecated;
  SVarTypeAlreadyUsed =      SVarTypeAlreadyUsedWithPrefix deprecated;
  SVarTypeNotUsable =        SVarTypeNotUsableWithPrefix deprecated;
  SInvalidVarOpWithHResult = SInvalidVarOpWithHResultWithPrefix deprecated;
  SVarTypeTooManyCustom =    SVarTypeTooManyCustomTypes deprecated;}

  sUnknownFromType = 'Cannot convert from the specified type';
  sUnknownToType = 'Cannot convert to the specified type';
  SExternalException = 'External exception %x';
  SAssertionFailed = 'Assertion failed';
  SIntfCastError = 'Interface not supported';
  SSafecallException = 'Exception in safecall method';
  SAssertError = '%s (%s, line %d)';
  SAbstractError = 'Abstract Error';
  SModuleAccessViolation = 'Access violation at address %p in module ''%s''. %s of address %p';
  SCannotReadPackageInfo = 'Cannot access package information for package ''%s''';
  sErrorLoadingPackage = 'Can''t load package %s.'+sLineBreak+'%s';
  SInvalidPackageFile = 'Invalid package file ''%s''';
  SInvalidPackageHandle = 'Invalid package handle';
  SDuplicatePackageUnit = 'Cannot load package ''%s.''  It contains unit ''%s,''' +
    'which is also contained in package ''%s''';
  SOSError = 'System Error.  Code: %d.'+sLineBreak+'%s';
  SUnkOSError = 'A call to an OS function failed';
  SWin32Error = 'Win32 Error.  Code: %d.'#10'%s' deprecated; // use SOSError
  SUnkWin32Error = 'A Win32 API function failed' deprecated; // use SUnkOSError
  SNL = 'Application is not licensed to use this feature';

  SShortMonthNameJan = 'Jan';
  SShortMonthNameFeb = 'Feb';
  SShortMonthNameMar = 'Mar';
  SShortMonthNameApr = 'Apr';
  SShortMonthNameMay = 'May';
  SShortMonthNameJun = 'Jun';
  SShortMonthNameJul = 'Jul';
  SShortMonthNameAug = 'Aug';
  SShortMonthNameSep = 'Sep';
  SShortMonthNameOct = 'Oct';
  SShortMonthNameNov = 'Nov';
  SShortMonthNameDec = 'Dec';

  SLongMonthNameJan = 'January';
  SLongMonthNameFeb = 'February';
  SLongMonthNameMar = 'March';
  SLongMonthNameApr = 'April';
  SLongMonthNameMay = 'May';
  SLongMonthNameJun = 'June';
  SLongMonthNameJul = 'July';
  SLongMonthNameAug = 'August';
  SLongMonthNameSep = 'September';
  SLongMonthNameOct = 'October';
  SLongMonthNameNov = 'November';
  SLongMonthNameDec = 'December';

  SShortDayNameSun = 'Sun';
  SShortDayNameMon = 'Mon';
  SShortDayNameTue = 'Tue';
  SShortDayNameWed = 'Wed';
  SShortDayNameThu = 'Thu';
  SShortDayNameFri = 'Fri';
  SShortDayNameSat = 'Sat';

  SLongDayNameSun = 'Sunday';
  SLongDayNameMon = 'Monday';
  SLongDayNameTue = 'Tuesday';
  SLongDayNameWed = 'Wednesday';
  SLongDayNameThu = 'Thursday';
  SLongDayNameFri = 'Friday';
  SLongDayNameSat = 'Saturday';

  SCannotCreateDir = 'Unable to create directory';
  SCodesetConversionError = 'Codeset conversion failure';

  // Added in VCL.NET
  SThreadingModel = 'Invalid threading model (%sThreadAttribute is required)';
  SNonstandardException = 'Exception %s';

  SInvalidTypeConversion = 'Invalid type conversion';

implementation

end.
